	.INCLUDE "EQUATES.S"
****
*
* KERNAL BANK
*
* DUNGEON 2600 PROGRAM
*
* WRITTEN BY ADAM CLAYTON
* DEVELOPED BY SCULPTURED SOFTWARE
* COPYRIGHT 1987 ATARI
* 
*
****
	ORG	$F101
****
*
* KERNAL PROGRAM TO CHECK AND DO BOTH PLAYER RESETS
*  STARTUP KERNAL
*
****
SETUP:
	JMP	.3
.1:
	DEX			;17
	BNE	.1
	STA	RESP0		;22 - 42
	LDY	PTYPE0
	LDA	PDATA,Y
	TAY			;51
	LDA	PTYPEHI,Y
	STA	ADDRP0+1
	LDA	PTYPELO,Y	;62
	STA	ADDRP0
	LDA	HORIP1
	JMP	.5		;69
.2:
	DEX			;17
	BNE	.2
	STA	RESP1		;22 - 42
	LDA	PDATA,Y
	TAY
	LDA	PTYPEHI,Y	;52
	STA	ADDRP1+1
	LDA	PTYPELO,Y
	STA	ADDRP1		;62
	LDA	PLREF1
	STA	REFP1
	JMP	.7		;71
.3:
	STA	WSYNC
	LDA	HORIP0		;3
	STA	HMP0
	AND	#$0F
	LSR
	TAX
	BCS	.1
	LDY	PTYPE0		;17
	LDA	PDATA,Y
	TAY
	LDA	PTYPEHI,Y
	STA	ADDRP0+1
	LDA	PTYPELO,Y	;34
	STA	ADDRP0
	LDA	HORIP1		;40
.4:
	DEX
	BNE	.4
	STA	RESP0		;47 - 72
.5:
	STA	WSYNC
	LDY	PTYPE1		;3
	STA	HMP1
	AND	#$0F
	LSR
	TAX
	BCS	.2
	LDA	PDATA,Y 	;18
	TAY
	LDA	PTYPEHI,Y
	STA	ADDRP1+1
	LDA	PTYPELO,Y
	STA	ADDRP1		;34
	LDA	PLREF1
	STA	REFP1
.6:	DEX			;42
	BNE	.6
	STA	RESP1		;47 - 72
.7:
	LDA	PLREF0
	STA	REFP0
	LDY	PTYPE0
	LDX	PCOLOR,Y
	LDA	COHI,X
	STA	COLP0+1
	LDA	COLO,X
	STA	COLP0
	LDY	PTYPE1
	LDX	PCOLOR,Y
	LDA	COHI,X
	STA	COLP1+1
	LDA	COLO,X
	STA	COLP1
	LDA	RAMPF2+SARA
	STA	PF2
	LDA	RAMPF1+SARA
	STA	PF1
	LDA	RAMPF0+SARA
	STA	PF0
	JMP	.9
.8:
	DEX			;17
	BNE	.8
	STA	RESBL		;22 - 42
	LDA	WINDOW
	EOR	#$0F
	AND	#$0F
	STA	V1CNT	;52
	LDA	WINDOW
	AND	#$03
	TAY
	LDA	LTAB,Y		;63
	STA	VCOUNT
	LDA	#69
	JMP	.11		;71
.9:
	STA	WSYNC
	LDA	HMBALL		;3
	STA	HMBL
	AND	#$0F
	LSR
	TAX
	BCS	.8
	LDA	WINDOW		;17
	EOR	#$0F
	AND	#$0F
	STA	V1CNT
	LDA	WINDOW		;27
	AND	#$03
	TAY
	LDA	LTAB,Y		;35
	STA	VCOUNT
	LDA	#69		;40
.10:
	DEX
	BNE	.10
	STA	RESBL		;47 - 72
.11:
	STA	LCOUNT
	LDA	WINDOW
	AND	#$0F
	STA	VOFFP0
	STA	VOFFP1
	LDA	VERTP0
	CLC
	BPL	.12
	ADC	#$FF
.12:
	CLC
	ADC	#$02
	SEC
	SBC	VOFFP0
	BPL	.13
	ADC	#14
	STA	WIDP0
	LDA	#$00
	STA	VOFFP0
	BEQ	.14
.13:
	STA	VOFFP0
	LDA	#14
	STA	WIDP0
.14:
	LDA	VERTP1
	CLC
	BPL	.15
	ADC	#$FF
.15:
	CLC
	ADC	#$02
	SEC
	SBC	VOFFP1
	BPL	.16
	ADC	#14
	STA	WIDP1
	LDA	#0
	STA	VOFFP1
	BEQ	.17
.16:
	STA	VOFFP1
	LDA	#14
	STA	WIDP1
.17:
	LDA	VOFFP0
	BNE	.22
	LDY	WIDP0
	DEY
	STY	WIDP0
	BMI	.23
	LDA	(ADDRP0),Y
	STA	GRP0
	LDA	(COLP0),Y
.18:
	STA	COLUP0
	LDA	VOFFP1
	BNE	.24
	LDY	WIDP1
	DEY
	STY	WIDP1
	BMI	.25
	LDA	(ADDRP1),Y
	STA	GRP1
	LDA	(COLP1),Y
.19:
	STA	COLUP1
	STA	WSYNC
	STA	HMOVE
	LDA	#1
	STA	VDELP0
	STA	VDELBL		;13
	STA	PFCNT
	STA	PCOUNT
	LDY	BALCNT
	BNE	.20
	LDA	#$02
.20:
	STA	ENABL
	STA	HMCLR
.WAIT: 
	INC	RANDOM
	LDA	INTIM
	BNE	.WAIT
	LDA	#$21
	STA	CTRLPF
	LDA	#00
	STA	VDELP1
	STA	NUSIZ1
	STA	WSYNC
	STA	VBLANK
	STA	NUSIZ0
	STA	NUSIZ1		;9
	LDA	COLOR+1
	STA	COLUBK
	LDA	COLOR
	STA	COLUPF
	LDA	V1CNT		;24
	BNE	.21
	JMP	MKERNAL
.21:
	NOP
	LDA	ADDRP1		;32
	JMP	MLOOP
.22:
	DEC	VOFFP0
	LDA	#$00
	STA	GRP0
	BEQ	.18
.23:
	LDA	#$00
	STA	GRP0
	STA	WIDP0
	BEQ	.18
.24:
	DEC	VOFFP1
	LDA	#$00
	STA	GRP1
	BEQ	.19
.25:
	LDA	#$00
	STA	GRP1
	STA	WIDP1
	BEQ	.19
PLAYER9:
	DC.B	$3E,$1C,$1C,$1C,$1C,$3E,$3E,$3E,$1C,$1C,$1C,$1C,$0C,$04
PLAYERA:
	DC.B	$0E,$3C,$1C,$1C,$1C,$3E,$3E,$3E,$1C,$1C,$1C,$1C,$1C,$08
PLAYERB:
	DC.B	$0E,$0C,$3C,$1C,$1C,$3E,$3E,$3E,$1C,$1C,$1C,$1C,$1C,$08
PLAYERC:
	DC.B	$38,$1E,$1C,$1C,$1C,$3E,$3E,$3E,$1C,$1C,$1C,$1C,$0C,$04

	ORG	$F300
****
*
* KERNAL PROGRAM TO DO P0 RESET AND CARRY P1 THROUGH
*	LTYPE = FF
*
****
MKERP0:
	BMI	.0		;44
	JMP	MKERP1		;46
.0:
	LDA	VOFFP1
	BNE	.3
	LDY	WIDP1
	DEY
	STY	WIDP1		;57
	BMI	.4
	LDA	(ADDRP1),Y	;64
	STA	TEMP
	LDA	(COLP1),Y	;72
.1:
	STA	WSYNC
	STA	TEMP+1		;3
	LDA	VOFFP1
	BNE	.5
	LDY	WIDP1
	DEY
	STY	WIDP1		;16
	BMI	.6
	LDA	(ADDRP1),Y
	STA	TEMP+2
	LDA	(COLP1),Y	;31
.2:
	STA	TEMP+3
	LDA	#$00
	STA	GRP0		;39
	DEC	BALCNT
	BNE	.21
	LDA	#2
.21:
	STA	ENABL		;51
	LDY	PCOUNT
	STA	HMCLR
	LDA	HORIP0,Y
	STA	HMP0
	AND	#$0F
	LSR
	STA	TEMP+4		;71
	STA	WSYNC
	LDA	TEMP		;3
	STA	GRP1
	LDA	TEMP+1
	STA	COLUP1
	LDA	PLREF0,Y
	STA	REFP0		;19
	DEC	LCOUNT
	BEQ	.8
	LDA	#$00
	DEC	BALCNT
	BNE	.25
	LDA	#$02
.25:
	STA	TEMP+1		;40
	LDY	PFCNT
	LDA	RAMPF0+SARA,Y
	STA	TEMP		;50
	LDA	RAMPF1+SARA,Y
	TAX
	LDA	RAMPF2+SARA,Y	;60
	LDY	TEMP
	JMP	.9		;66
.3:
	DEC	VOFFP1		;IF NOT READY DEC COUNTER AND CLEAR P0 VALUES
	LDA	#$00
	STA	TEMP
	JMP	.1	
.4:
	LDA	#$00		;IF ALREADY DONE THEN CLEAR COUNTER,
	STA	TEMP
	STA	WIDP1
	JMP	.1
.5:
	DEC	VOFFP1		;IF NOT READY DEC COUNTER AND CLEAR P1 VALUES
	LDA	#$00
	STA	TEMP+2
	JMP	.2
.6:
	LDA	#$00		;IF ALREADY DONE THEN CLEAR COUNTER,
	STA	TEMP+2
	STA	WIDP1
	JMP	.2
.7:
	DEX			;17
	BNE	.7
	STA	RESP0		;22 - 42
	LDA	TEMP+1
	STA	ENABL
	LDY	PCOUNT		;51
	LDA	VERTP0,Y
	STA	VOFFP0
	LDA	#14
	STA	WIDP0		;63
	INC	PFCNT
	JMP	.11		;71
.8:
	JMP	SCORE

.9:	STA	WSYNC
	STA	PF2		;3
	STX	PF1
	STY	PF0
	LDX	TEMP+4		;12
	BCS	.7
	LDA	TEMP+1		;17
	STA	ENABL
	LDY	PCOUNT
	LDA	VERTP0,Y	;27
	STA	VOFFP0
	LDA	#14
	STA	WIDP0
	INC	PFCNT		;40
.10:	DEX
	BNE	.10
	STA	RESP0		;47 - 72
.11:	STA	WSYNC
	LDA	TEMP+2		;3
	STA	GRP1
	LDA	TEMP+3
	STA	COLUP1		;12
	DEC	LCOUNT
	BEQ	.8
	LDX	PTYPE0,Y	;24
	LDY	PDATA,X
	LDA	PTYPEHI,Y
	STA	ADDRP0+1
	LDA	PTYPELO,Y
	STA	ADDRP0
	LDY	PCOLOR,X	;46
	LDA	COHI,Y
	STA	COLP0+1
	LDA	COLO,Y		;57
	STA	COLP0
	INC	PCOUNT
	JMP	MKEREND 	;68
	
****
*
* KERNAL PROGRAM TO DO P1 RESET AND CARRY P0 THROUGH
*	LTYPE = 1
*
****

MKERP1:
	CMP	#$01
	BEQ	.0		;51
	JMP	MKERNONE	;53
.0:
	STA	HMCLR		;54
	LDA	HORIP1,Y
	STA	HMP1
	AND	#$0F		;63
	LSR
	STA	TEMP+4		;68
	LDA	#0
	DEC	BALCNT		;75
	BNE	.05		;1
	LDA	#$02
.05:
	STA	ENABL		;6
	LDA	VOFFP0
	BNE	.3
	LDY	WIDP0		;14
	DEY
	STY	WIDP0
	BMI	.4		;21
	LDA	(ADDRP0),Y
	STA	GRP0
	LDA	(COLP0),Y	;34
.1:
	STA	TEMP
	LDA	VOFFP0
	BNE	.5
	LDY	WIDP0		;45
	DEY
	STY	WIDP0
	BMI	.6
	LDA	(ADDRP0),Y	;57
	STA	TEMP+1
	LDA	(COLP0),Y	;65
.2:
	LDX	#14
	STX	WIDP1		;70
	STA	WSYNC
	STA	TEMP+2		;3
	LDA	TEMP
	STA	COLUP0
	LDX	#$00
	STX	GRP1
	LDY	PCOUNT		;17
	LDA	PLREF1,Y
	STA	REFP1
	DEC	LCOUNT
	BEQ	.8		;31
	DEC	BALCNT
	BNE	.25
	LDX	#2
.25:
	STX	TEMP+3
	LDY	PFCNT		;46
	LDA	RAMPF0+SARA,Y
	STA	TEMP
	LDA	RAMPF1+SARA,Y
	TAX
	LDA	RAMPF2+SARA,Y	;63
	LDY	TEMP
	JMP	.9		;69
.3:
	DEC	VOFFP0
	LDA	#$00
	STA	GRP0
	JMP	.1	
.4:
	LDA	#$00
	STA	GRP0
	STA	WIDP0
	JMP	.1
.5:
	DEC	VOFFP0
	LDA	#$00
	STA	TEMP+1
	JMP	.2
.6:
	LDA	#$00
	STA	TEMP+1
	STA	WIDP0
	JMP	.2
.7:
	DEX			;17
	BNE	.7
	STA	RESP1		;22 - 42
	LDA	TEMP+3
	STA	ENABL
	LDA	TEMP+1		;51
	STA	GRP0
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1
	LDA	#0		;66
	JMP	.11		;69
.8:
	JMP	SCORE

.9:	STA	WSYNC
	STA	PF2		;3
	STX	PF1
	STY	PF0
	LDX	TEMP+4		;12
	BCS	.7
	LDA	TEMP+3
	STA	ENABL
	LDA	TEMP+1		;23
	STA	GRP0
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1
	LDA	#0
	NOP			;40
.10:	DEX
	BNE	.10
	STA	RESP1		;47-72
.11:	STA	WSYNC
	STA	GRP1		;3
	LDA	TEMP+2
	STA	COLUP0
	DEC	LCOUNT		;14
	BEQ	.8
*	LDY	PCOUNT
	LDX	PTYPE1,Y	;20
	LDY	PDATA,X
	LDA	PTYPEHI,Y
	STA	ADDRP1+1	;34
	LDA	PTYPELO,Y
	STA	ADDRP1
	LDY	PCOLOR,X
	LDA	COHI,Y		;49
	STA	COLP1+1
	LDA	COLO,Y
	STA	COLP1		;59
	INC	PCOUNT
	INC	PFCNT
	JMP	MKEREND 	;72
****
*
* PROGRAM TO DO NO RESETS
*	LTYPE = 2
****

MKERNONE:
	LDA	#15
	STA	V1CNT		;64
	LDA	#$00
	DEC	BALCNT		;71
	STA	WSYNC
	BNE	.05
	LDA	#2
.05:
	STA	ENABL		;7
	LDA	VOFFP0
	BNE	.6
	LDY	WIDP0
	DEY
	STY	WIDP0		;20
	BMI	.7
	LDA	(ADDRP0),Y
	STA	GRP0		;30
	LDA	(COLP0),Y
.1:
	STA	TEMP
	LDA	VOFFP1		;41
	BNE	.4
	LDY	WIDP1
	DEY
	STY	WIDP1		;51
	BMI	.5
	LDA	(ADDRP1),Y	;58
	TAX
	LDA	(COLP1),Y	;65
.3:
	STA	WSYNC
	STA	COLUP1
	STX	GRP1
	LDA	TEMP		;9
	STA	COLUP0
	INC	PCOUNT		;17
	DEC	LCOUNT		;22
	BEQ	.8
	LDA	#1
	STA	VCOUNT
	JMP	MLOOP		;32
.4:
	DEC	VOFFP1
	LDA	#$00
	TAX
	JMP	.3
.5:
	LDA	#$00
	TAX
	STA	WIDP1
	BEQ	.3
.6:
	DEC	VOFFP0
	LDA	#$00
	STA	GRP0
	BEQ	.1
.7:
	LDA	#$00
	STA	GRP0
	STA	WIDP0
	BEQ	.1
.8:
	JMP	SCORE

DAGGER: 
	DC.B	$00,$00,$00,$10,$10,$10,$10,$38,$10,$10,$00,$00,$00,$00
DAGGERC:
	DC.B	$00,$00,$00,$0A,$0A,$0A,$0A,$06,$06,$06,$00,$00,$00,$00
GUNC:	
	DC.B	$00,$00,$00,$00,$04,$04,$06,$06,$08,$0A,$00,$00,$00,$00
GUN:	
	DC.B	$00,$00,$00,$00,$E0,$E0,$F8,$E8,$7F,$80,$00,$00,$00,$00
SHIELD: 
	DC.B	$00,$00,$38,$7C,$EE,$EE,$82,$EE,$EE,$FE,$6C,$00,$00,$00
SHIELDC:
	DC.B	$00,$00,$C4,$C4,$C4,$C6,$C6,$C8,$C8,$C8,$C8,$00,$00,$00
CHALACE:
	DC.B	$00,$00,$00,$38,$10,$10,$10,$28,$44,$44,$44,$00,$00,$00
GOLDC:
	DC.B	$00,$00,$00,$28,$28,$28,$28,$2A,$2A,$2A,$2C,$00,$00,$00
SILVERC:
	DC.B	$00,$00,$00,$08,$08,$08,$08,$0A,$0A,$0A,$0C,$00,$00,$00
	ORG	$F5FC
****
*
* KERNAL PROGRAM TO CHECK AND DO BOTH PLAYER RESETS
*    LTYPE = 0
****

MKERNAL:
	LDY	PCOUNT		;32
	LDA	LTYPE,Y
	BEQ	.1
	JMP	MKERP0		;41
.05:
	JMP	SDONE
.1:
	LDA	HORIP0,Y	;43
	STA	HMP0
	AND	#$0F
	STA	TEMP+1		;51
	LDX	PTYPE1,Y
	LDY	PDATA,X
	LDA	PTYPEHI,Y	;63
	STA	ADDRP1+1
	LDA	PTYPELO,Y
	STA	ADDRP1		;73
	LDY	PCOLOR,X	;1
	LDA	COHI,Y
	STA	COLP1+1 	;8
	LDA	COLO,Y
	STA	COLP1
	LDA	#0		;17
	STA	GRP0
	DEC	BALCNT		;25
	BNE	.2
	LDA	#$02
.2:
	STA	ENABL		;32
	LDY	PCOUNT
	LDX	PTYPE0,Y
	LDY	PDATA,X 	;43
	LDA	PTYPEHI,Y
	STA	ADDRP0+1
	LDA	PTYPELO,Y	;54
	STA	ADDRP0
	LDY	PCOLOR,X
	LDA	COHI,Y		;65
	STA	COLP0+1
	LDA	COLO,Y		;72
	STA	COLP0		;75
	LDA	#$00		;1
	STA	GRP1		;4
	DEC	BALCNT
	BNE	.3
	LDA	#$02
.3:
	STA	TEMP+2		;16
	LDY	PCOUNT
	LDA	PLREF1,Y
	STA	REFP1		;26
	LDA	HORIP1,Y
	STA	HMP1
	AND	#$0F		;35
	LSR
	STA	TEMP
	DEC	LCOUNT		;45
	BEQ	.5
	LDY	PFCNT
	LDA	RAMPF0+SARA,Y	;53
	TAX
	LDA	RAMPF2+SARA,Y	;60
	STA	PF2
	LDA	RAMPF1+SARA,Y	;66
	JMP	.7
.4:
	DEX
	BNE	.4
	STA	RESP1
	STY	ENABL
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1
	LDA	#14
	STA	WIDP0
	STA	WIDP1
	LDA	TEMP+1
	LSR
	JMP	.9
.5:
	JMP	SCORE
.6:
	SBC	#$01		;17
	BNE	.6
	STA	RESP0		;22 - 42
	DEC	LCOUNT
	BEQ	.5
	LDA	VERTP0,Y
	STA	VOFFP0		;56
	INC	PFCNT
	INC	PCOUNT		;66
	JMP	MKEREND 	;69
.7:
	STA	WSYNC
	STA	PF1		;3
	STX	PF0
	LDY	TEMP+2
	LDX	TEMP		;12
	BCS	.4
	STY	ENABL		;17
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1		;27
	LDA	#14
	STA	WIDP0
	STA	WIDP1		;35
	LDA	TEMP+1
	LSR
.8:
	DEX
	BNE	.8		;44
	STA	RESP1		;47 - 72
.9:
	STA	WSYNC
	LDX	#$00
	STX	GRP1		;5
	LDX	PLREF0,Y
	STX	REFP0
	BCS	.6
	DEC	LCOUNT
	BEQ	.5
	LDX	VERTP0,Y
	STX	VOFFP0
	TAX			;30
	INC	PFCNT
	INC	PCOUNT
.10:
	DEX
	BNE	.10		;44
	STA	RESP0		;47 - 72
MKEREND:
	STA	WSYNC
	STA	HMOVE
	LDA	VOFFP1
	BNE	.5
	LDY	WIDP1		;11
	DEY
	STY	WIDP1
	BMI	.6
	LDA	(ADDRP1),Y	;23
	STA	TEMP
	LDA	(COLP1),Y
.1:	TAX
	LDA	#3		;34
	STA	VCOUNT
	DEC	BALCNT
	BEQ	.2
	LDA	#0		;46
.2:
	STA	ENABL
	LDA	VOFFP0
	BNE	.7
	LDY	WIDP0
	DEY			;59
	STY	WIDP0
	BMI	.8
	LDA	(ADDRP0),Y
	STA	GRP0		;72
	STA	WSYNC
	LDA	(COLP0),Y
.3:
	LDY	TEMP		;8
	STA	COLUP0
	STY	GRP1
	STX	COLUP1
	LDA	#13		;19
	STA	V1CNT
	DEC	LCOUNT
	BEQ	.4
	JMP	MLOOP		;33
.4:
	JMP	SDONE

.5:
	DEC	VOFFP1
	LDA	#$00
	STA	TEMP
	BEQ	.1
.6:
	STA	TEMP
	STA	WIDP1
	JMP	.1

.7:
	DEC	VOFFP0
	LDA	#$00
	STA	GRP0
	STA	WSYNC
	BEQ	.3

.8:
	STA	GRP0
	STA	WIDP0
	STA	WSYNC
	JMP	.3
****
*
* MAIN KERNAL LOOP
* DOES PLAYERS AND PLAYFIELD IF NEEDED
* ALSO CHECKS FOR END OF SCREEN AND NEXT RESET
*
****
MLOOP:
	LDA	VOFFP1		;36
	BNE	.4
	LDY	WIDP1
	DEY
	STY	WIDP1
	BMI	.5		;48
	LDA	(ADDRP1),Y
	STA	TEMP
	LDA	(COLP1),Y	;61
.1:
	TAX
	LDY	PFCNT	;66
	DEC	VCOUNT		;71
	BNE	.2
	LDA	RAMPF1+SARA,Y	;76
	STA	PF1
	LDA	RAMPF0+SARA,Y	;07
	STA	PF0
	LDA	RAMPF2+SARA,Y
	STA	PF2		;17
	INC	PFCNT
	LDA	#$04
	STA	VCOUNT		;27
.2:
	LDA	#$00
	DEC	BALCNT
	BNE	.25
	LDA	#$02		;38
.25:
	STA	ENABL
	LDA	VOFFP0
	BNE	.6
	LDY	WIDP0
	DEY			;51
	STY	WIDP0
	BMI	.7
	LDA	(ADDRP0),Y	;61
	STA	GRP0		;64
	LDA	(COLP0),Y	;69
.3:
	STA	WSYNC
	STA	COLUP0		;3
	STX	COLUP1
	LDA	TEMP
	STA	GRP1
	DEC	LCOUNT		;17
	BEQ	.8
	DEC	V1CNT		;24
	BNE	MLOOP
	JMP	MKERNAL 	;29
.4:
	DEC	VOFFP1
	LDA	#$01
	SEC
.41:
	SBC	#$01
	BNE	.41
	STA	TEMP
	JMP	.1
.5:
	LDA	#$00
	STA	TEMP
	STA	WIDP1
	JMP	.1
.6:
	DEC	VOFFP0
	LDA	#$00
	STA	GRP0
	JMP	.3
.7:
	LDA	#$00
	STA	GRP0
	STA	WIDP0
	JMP	.3

.8:
SDONE:
SCORE:
	JMP	TBANK
	ORG	$F800
***
*
* PLAYER GRAPHICS AND COLOR DATA
*
****
PLAYER1:
	DC.B	$3C,$38,$38,$38,$38,$74,$6C,$6C,$38,$38,$38,$38,$30,$20
PLAYER2:
	DC.B	$7E,$6C,$7C,$38,$38,$74,$6C,$6C,$38,$38,$38,$38,$30,$20
PLAYER3:
	DC.B	$E6,$C7,$FE,$7C,$38,$78,$74,$74,$38,$38,$38,$38,$30,$20
PLAYER4:
	DC.B	$3E,$1C,$1C,$1C,$1C,$36,$2E,$2E,$1C,$1C,$1C,$1C,$18,$10
PLAYER5:
	DC.B	$38,$1E,$1C,$1C,$1C,$36,$2E,$2E,$1C,$1C,$1C,$1C,$18,$10
PLAYER6:
	DC.B	$38,$18,$1E,$1C,$1C,$36,$2E,$2E,$1C,$1C,$1C,$1C,$18,$10
PLAYER7:
	DC.B	$0E,$3C,$1C,$1C,$1C,$36,$2E,$2E,$1C,$1C,$1C,$1C,$1C,$08
PLAYER8:
	DC.B	$0E,$0C,$3C,$1C,$1C,$36,$2E,$2E,$1C,$1C,$1C,$1C,$1C,$08
PLAYER1C:
	DC.B	$24,$24,$24,$24,$26,$26,$26,$26,$26,$F8,$F8,$F8,$22,$22
PLAYER2C:
	DC.B	$24,$24,$24,$24,$26,$26,$26,$26,$26,$F8,$00,$00,$22,$22
PLAYER3C:
	DC.B	$34,$34,$34,$34,$36,$36,$36,$36,$36,$F8,$F8,$F8,$32,$32
PLAYER4C:
	DC.B	$34,$34,$34,$34,$36,$36,$36,$36,$36,$F8,$00,$00,$32,$32
GRUNT1: 
	DC.B	$3F,$3E,$3E,$3E,$3E,$27,$2F,$3F,$3E,$3C,$3F,$3C,$3C,$00
GRUNT2: 
	DC.B	$77,$7E,$3E,$3E,$3E,$33,$37,$3F,$3E,$3C,$3F,$3C,$3C,$00
GRUNT3: 
	DC.B	$67,$FE,$7E,$3E,$3E,$39,$3B,$3F,$3E,$3C,$3F,$3C,$3C,$00
GRUNT4: 
	DC.B	$FF,$7E,$7E,$7E,$FF,$FF,$FF,$FF,$7E,$3C,$3C,$3C,$3C,$00
GRUNT5: 
	DC.B	$F0,$7F,$7E,$7E,$FE,$FF,$FF,$FF,$7E,$3C,$3C,$3C,$3C,$00
GRUNT6: 
	DC.B	$F8,$78,$7F,$7E,$FE,$FE,$FF,$FF,$7E,$3C,$3C,$3C,$3C,$00
	ORG	$F900
GRUNT7:
	DC.B	$0F,$FE,$7E,$7E,$7F,$FF,$FF,$FF,$7E,$3C,$3C,$3C,$3C,$00
GRUNT8: 
	DC.B	$0F,$0E,$FE,$7E,$7F,$7F,$FF,$FF,$7E,$3C,$3C,$3C,$3C,$00
GREEN:
	DC.B	$38,$38,$38,$34,$38,$38,$38,$38,$38,$26,$26,$26,$38,$00
GREEN1:
	DC.B	$38,$38,$38,$34,$38,$38,$38,$38,$38,$38,$38,$38,$38,$00
GHOST1:
	DC.B	$FC,$7C,$3E,$3E,$3F,$1E,$1E,$0F,$0F,$0F,$07,$00,$00,$00
GHOST2:
	DC.B	$F8,$FC,$7C,$3E,$3F,$1E,$1E,$0F,$0F,$0F,$07,$00,$00,$00
GHOST3:
	DC.B	$FC,$7C,$3E,$3E,$1F,$1E,$1E,$0F,$0F,$0F,$07,$00,$00,$00
GHOST4:
	DC.B	$3F,$7E,$7E,$7E,$FE,$7C,$38,$38,$38,$38,$10,$00,$00,$00
GHOST5:
	DC.B	$1F,$3F,$7E,$7E,$FE,$7C,$38,$38,$38,$38,$10,$00,$00,$00
GHOST6:
	DC.B	$3F,$3F,$7E,$7E,$FE,$7C,$38,$38,$38,$38,$10,$00,$00,$00
GHOST7:
	DC.B	$FC,$7E,$7E,$3E,$3F,$3E,$1C,$14,$14,$14,$08,$00,$00,$00
GHOST8:
	DC.B	$F8,$FC,$7E,$3E,$3F,$3E,$1C,$14,$14,$14,$08,$00,$00,$00
GHOST9:
	DC.B	$FC,$7C,$3E,$3E,$3F,$3E,$1C,$14,$14,$14,$08,$00,$00,$00
GHOSTC:
	DC.B	$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C
SKELT1:
	DC.B	$18,$10,$10,$10,$14,$08,$30,$18,$30,$00,$18,$38,$30,$18
SKELT2:
	DC.B	$3C,$28,$28,$10,$12,$04,$38,$18,$30,$00,$18,$38,$30,$18
SKELT3:
	DC.B	$63,$42,$42,$24,$18,$42,$34,$18,$30,$00,$18,$38,$30,$18
SKELT4:
	DC.B	$63,$14,$14,$14,$55,$41,$5D,$41,$36,$00,$1C,$1C,$1C,$1C
	ORG	$FA00
SKELT5:
	DC.B	$60,$13,$14,$14,$55,$41,$5D,$41,$36,$00,$1C,$1C,$1C,$1C
SKELT6:
	DC.B	$03,$64,$14,$14,$55,$41,$5D,$41,$36,$00,$1C,$1C,$1C,$1C
SKELT7:
	DC.B	$63,$14,$14,$14,$55,$41,$5D,$41,$36,$00,$14,$1C,$08,$1C
SKELT8:
	DC.B	$60,$13,$14,$14,$55,$41,$5D,$41,$36,$00,$14,$1C,$08,$1C
SKELT9:
	DC.B	$03,$64,$14,$14,$55,$41,$5D,$41,$36,$00,$14,$1C,$08,$1C
SKELTC:
	DC.B	$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C
WIZRD1:
	DC.B	$FC,$7C,$7E,$7E,$3F,$3F,$3E,$3E,$1C,$1C,$1C,$1C,$38,$10
WIZRD2:
	DC.B	$7E,$7E,$7E,$3E,$3E,$3F,$3F,$3E,$1C,$1C,$1C,$1C,$38,$10
WIZRD3:
	DC.B	$FF,$7F,$7F,$7E,$3E,$3F,$3F,$3E,$1C,$1C,$1C,$1C,$38,$10
WIZRD4:
	DC.B	$1C,$3E,$3E,$3E,$7F,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD5:
	DC.B	$18,$3C,$3E,$3E,$3F,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD6:
	DC.B	$18,$3C,$3C,$3E,$3F,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD7:
	DC.B	$0C,$1E,$3E,$3E,$7E,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD8:
	DC.B	$0C,$1E,$1E,$3E,$7E,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD1C:
	DC.B	$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$28,$28,$28,$CA,$CA
WIZRD2C:
	DC.B	$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$28,$CA,$CA,$CA,$CA
DEATH1:
	DC.B	$F8,$78,$7C,$7C,$3E,$3E,$3E,$3F,$3C,$38,$38,$18,$18,$0C
DEATH2:
	DC.B	$F0,$F8,$78,$7C,$3E,$3E,$3E,$3F,$3C,$38,$38,$18,$18,$0C
	ORG	$FB00
DEATH3:
	DC.B	$F8,$7C,$7E,$3E,$3E,$3E,$3E,$3F,$3C,$38,$38,$18,$18,$0C
DEATH4:
	DC.B	$FF,$7F,$3F,$3E,$1E,$1F,$0F,$0F,$0F,$1F,$3E,$6E,$4E,$04
DEATH5:
	DC.B	$7F,$7F,$7E,$3E,$1E,$1F,$0F,$0F,$0F,$1F,$3E,$6E,$4E,$04
DEATH6:
	DC.B	$FF,$7F,$7E,$3E,$1E,$1F,$0F,$0F,$0F,$1F,$3E,$6E,$4E,$04
DEATH7:
	DC.B	$FF,$FE,$FC,$7C,$78,$F8,$F0,$F6,$FC,$D8,$50,$50,$50,$20
DEATH8:
	DC.B	$FE,$FE,$7E,$7C,$78,$F8,$F0,$F6,$FC,$D8,$50,$50,$50,$20
DEATH9:
	DC.B	$FE,$FE,$7C,$7C,$F8,$F8,$F0,$F6,$FC,$D8,$50,$50,$50,$20
DEATHC:
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
KEY:
	DC.B	$00,$00,$00,$00,$00,$35,$4F,$30,$00,$00,$00,$00,$00,$00
KEYC:
	DC.B	$22,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$22,$00
KEYHOLE:
	DC.B	$FE,$FE,$FE,$EE,$EE,$C6,$82,$82,$C6,$EE,$FE,$FE,$FE,$00
CHEST:
	DC.B	$00,$00,$00,$7F,$7F,$7F,$6B,$77,$7F,$3E,$00,$00,$00,$00
CHESTC:
	DC.B	$00,$00,$00,$22,$26,$26,$26,$26,$22,$24,$00,$00,$00,$00
STAIR:	
	DC.B	$FF,$81,$81,$FF,$81,$BD,$81,$99,$81,$81,$81,$81,$81,$FF
STAIRC:
	DC.B	$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A
GENERATE:
	DC.B	$00,$00,$E7,$10,$08,$E7,$1C,$62,$FF,$EB,$C9,$FF,$7E,$00
GENC:
	DC.B	$00,$00,$08,$08,$08,$08,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$00
NONE:
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	ORG	$FC00
FOOD:
	DC.B	$00,$00,$00,$7E,$FF,$FF,$FF,$7F,$1E,$0D,$0C,$00,$00,$00
POISON:
	DC.B	$00,$00,$00,$7E,$EB,$F7,$EB,$7F,$1E,$0D,$0C,$00,$00,$00
FOODC:
	DC.B	$00,$00,$00,$26,$26,$26,$26,$26,$26,$26,$24,$00,$00,$00
EXPLO1: 
	DC.B	$10,$00,$02,$00,$00,$00,$08,$00,$00,$00,$00,$40,$00,$00
EXPLO2: 
	DC.B	$40,$00,$02,$00,$80,$01,$00,$02,$40,$00,$08,$00,$01,$80
EXPLO3: 
	DC.B	$40,$00,$02,$00,$80,$01,$00,$02,$40,$00,$08,$00,$01,$80
EXPLO4: 
	DC.B	$20,$08,$12,$82,$20,$22,$02,$24,$24,$00,$08,$01,$40,$00
AMULET: 
	DC.B	$00,$00,$00,$18,$3C,$3C,$18,$24,$42,$21,$02,$00,$00,$00
PDATA:
* OBJECTS
	DC.B	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
* PLAYER0
	DC.B	$10,$11,$12,$10,$11,$4F,$4A,$4B,$4C,$4D,$4E,$13,$14,$15,$16,$17
* PLAYER1
	DC.B	$10,$11,$4F,$10,$11,$12,$4A,$4D,$4E,$4B,$4C,$13,$16,$17,$14,$15
* GRUNT
	DC.B	$18,$19,$1A,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$1B,$1C,$1D,$1E,$1F
* SKELETON
	DC.B	$29,$2A,$2B,$29,$2A,$2B,$2C,$2C,$2D,$2C,$2E,$2F,$2F,$30,$2F,$31
* GHOST
	DC.B	$20,$21,$22,$20,$21,$22,$23,$24,$25,$25,$24,$26,$27,$28,$28,$27
* WIZARD
	DC.B	$32,$33,$34,$32,$33,$34,$35,$36,$37,$38,$39,$35,$36,$37,$38,$39
* DEATH
	DC.B	$3A,$3B,$3C,$3A,$3B,$3C,$3D,$3E,$3F,$3F,$3E,$40,$41,$42,$42,$41
* EMPTY
	DC.B	$43,$44,$45,$46,$47,$48,$49
	ORG	$FD00
BOMB:
	DC.B	$00,$00,$00,$1C,$3E,$7F,$7F,$3E,$1C,$08,$04,$00,$00,$00
BOMBC:
	DC.B	$00,$00,$00,$44,$44,$44,$44,$44,$44,$00,$00,$00,$00,$00
PCOLOR:
* OBJECTS
	DC.B	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
* PLAYER0
	DC.B	$10,$10,$10,$10,$10,$10,$11,$11,$11,$11,$11,$10,$10,$10,$10,$10
* PLAYER1
	DC.B	$12,$12,$12,$12,$12,$12,$13,$13,$13,$13,$13,$12,$12,$12,$12,$12
* GRUNT
	DC.B	$14,$14,$14,$14,$14,$14,$15,$15,$15,$15,$15,$14,$14,$14,$14,$14
* SKELETON
	DC.B	$17,$17,$17,$17,$17,$17,$17,$17,$17,$17,$17,$17,$17,$17,$17,$17
* GHOST
	DC.B	$16,$16,$16,$16,$16,$16,$16,$16,$16,$16,$16,$16,$16,$16,$16,$16
* WIZARD
	DC.B	$18,$18,$18,$18,$18,$18,$19,$19,$19,$19,$19,$18,$18,$18,$18,$18
* DEATH
	DC.B	$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A
* EMPTY
	DC.B	$1B,$1F,$1E,$1D,$1C,$16,$16
****
*
* ADDRESSES OF PLAYER DATA
*
****
PTYPELO:
	DC.B	NONE&$FF,CHEST&$FF,CHALACE&$FF,AMULET&$FF
	DC.B	CHALACE&$FF,GUN&$FF,DAGGER&$FF,SHIELD&$FF
	DC.B	TRAP&$FF,POISON&$FF,FOOD&$FF,BOMB&$FF
	DC.B	KEY&$FF,KEYHOLE&$FF,STAIR&$FF,GENERATE&$FF
* $10
	DC.B	PLAYER1&$FF,PLAYER2&$FF,PLAYER3&$FF
	DC.B	PLAYER4&$FF,PLAYER5&$FF,PLAYER6&$FF
	DC.B	PLAYER7&$FF,PLAYER8&$FF
* $18
	DC.B	GRUNT1&$FF,GRUNT2&$FF,GRUNT3&$FF
	DC.B	GRUNT4&$FF,GRUNT5&$FF,GRUNT6&$FF
	DC.B	GRUNT7&$FF,GRUNT8&$FF
* $20
	DC.B	GHOST1&$FF,GHOST2&$FF,GHOST3&$FF
	DC.B	GHOST4&$FF,GHOST5&$FF,GHOST6&$FF
	DC.B	GHOST7&$FF,GHOST8&$FF,GHOST9&$FF
* $29
	DC.B	SKELT1&$FF,SKELT2&$FF,SKELT3&$FF
	DC.B	SKELT4&$FF,SKELT5&$FF,SKELT6&$FF
	DC.B	SKELT7&$FF,SKELT8&$FF,SKELT9&$FF
* $32
	DC.B	WIZRD1&$FF,WIZRD2&$FF,WIZRD3&$FF
	DC.B	WIZRD4&$FF,WIZRD5&$FF,WIZRD6&$FF
	DC.B	WIZRD7&$FF,WIZRD8&$FF
* $3A
	DC.B	DEATH1&$FF,DEATH2&$FF,DEATH3&$FF
	DC.B	DEATH4&$FF,DEATH5&$FF,DEATH6&$FF
	DC.B	DEATH7&$FF,DEATH8&$FF,DEATH9&$FF
	DC.B	NONE&$FF,EXPLO1&$FF,EXPLO2&$FF
	DC.B	EXPLO3&$FF,EXPLO4&$FF,EXPLO5&$FF
	DC.B	EXPLO6&$FF,PLAYER9&$FF,PLAYERA&$FF
	DC.B	PLAYERB&$FF,PLAYERC&$FF,PLAYERD&$FF
	DC.B	PLAYERE&$FF
	ORG	$FE00
PTYPEHI:
	DC.B	NONE/256,CHEST/256,CHALACE/256,AMULET/256
	DC.B	CHALACE/256,GUN/256,DAGGER/256,SHIELD/256
	DC.B	TRAP/256,POISON/256,FOOD/256,BOMB/256
	DC.B	KEY/256,KEYHOLE/256,STAIR/256,GENERATE/256
	DC.B	PLAYER1/256,PLAYER2/256,PLAYER3/256
	DC.B	PLAYER4/256,PLAYER5/256,PLAYER6/256
	DC.B	PLAYER7/256,PLAYER8/256
	DC.B	GRUNT1/256,GRUNT2/256,GRUNT3/256
	DC.B	GRUNT4/256,GRUNT5/256,GRUNT6/256
	DC.B	GRUNT7/256,GRUNT8/256
	DC.B	GHOST1/256,GHOST2/256,GHOST3/256
	DC.B	GHOST4/256,GHOST5/256,GHOST6/256
	DC.B	GHOST7/256,GHOST8/256,GHOST9/256
	DC.B	SKELT1/256,SKELT2/256,SKELT3/256
	DC.B	SKELT4/256,SKELT5/256,SKELT6/256
	DC.B	SKELT7/256,SKELT8/256,SKELT9/256
	DC.B	WIZRD1/256,WIZRD2/256,WIZRD3/256
	DC.B	WIZRD4/256,WIZRD5/256,WIZRD6/256
	DC.B	WIZRD7/256,WIZRD8/256
	DC.B	DEATH1/256,DEATH2/256,DEATH3/256
	DC.B	DEATH4/256,DEATH5/256,DEATH6/256
	DC.B	DEATH7/256,DEATH8/256,DEATH9/256
	DC.B	NONE/256,EXPLO1/256,EXPLO2/256
	DC.B	EXPLO3/256,EXPLO4/256,EXPLO5/256
	DC.B	EXPLO6/256,PLAYER9/256,PLAYERA/256
	DC.B	PLAYERB/256,PLAYERC/256,PLAYERD/256
	DC.B	PLAYERE/256
****
*
* ADDRESSES OF COLOR INFORMATION
*
****
COLO:
	DC.B	NONE&$FF,CHESTC&$FF,SILVERC&$FF,GOLDC&$FF
	DC.B	GOLDC&$FF,GUNC&$FF,DAGGERC&$FF,SHIELDC&$FF
	DC.B	DEATHC&$FF,FOODC&$FF,FOODC&$FF,BOMBC&$FF
	DC.B	KEYC&$FF,KEYC&$FF,STAIRC&$FF,GENC&$FF
* $10
	DC.B	PLAYER1C&$FF,PLAYER2C&$FF,PLAYER3C&$FF
	DC.B	PLAYER4C&$FF
* $15
	DC.B	GREEN&$FF,GREEN1&$FF
	DC.B	GHOSTC&$FF
	DC.B	SKELTC&$FF
	DC.B	WIZRD1C&$FF,WIZRD2C&$FF
	DC.B	DEATHC&$FF
	DC.B	NONE&$FF,FIRE1&$FF,FIRE2&$FF
	DC.B	FIRE3&$FF,FIRE4&$FF
COHI:
	DC.B	NONE/256,CHESTC/256,SILVERC/256,GOLDC/256
	DC.B	GOLDC/256,GUNC/256,DAGGERC/256,SHIELDC/256
	DC.B	DEATHC/256,FOODC/256,FOODC/256,BOMBC/256
	DC.B	KEYC/256,KEYC/256,STAIRC/256,GENC/256
	DC.B	PLAYER1C/256,PLAYER2C/256,PLAYER3C/256
	DC.B	PLAYER4C/256
	DC.B	GREEN/256,GREEN1/256
	DC.B	GHOSTC/256
	DC.B	SKELTC/256
	DC.B	WIZRD1C/256,WIZRD2C/256
	DC.B	DEATHC/256
	DC.B	NONE/256,FIRE1/256,FIRE2/256
	DC.B	FIRE3/256,FIRE4/256
LTAB:
	DC.B	1,$4,$3,$2
UPHORIZ:
	LDY	#$05
.1:
	LDX	HORIP0,Y
	LDA	HTAB,X
	STA	HORIP0,Y
	LDX	HORIP1,Y
	LDA	HTAB,X
	STA	HORIP1,Y
	DEY
	BPL	.1
	LDX	HMBALL
	LDA	HTAB,X
	STA	HMBALL
	JMP	SETUP
****
*
* HORIZONTAL POSITION BYTES FOR PLAYER MOVEMENT
*
****
HTAB:
	DC.B $33,$23,$13,$03
	DC.B $F3,$E3,$D3,$C3,$B3,$A3,$93
	DC.B $75,$65,$55,$45,$35,$25,$15,$05
	DC.B $F5,$E5,$D5,$C5,$B5,$A5,$95
	DC.B $77,$67,$57,$47,$37,$27,$17,$07
	DC.B $F7,$E7,$D7,$C7,$B7,$A7,$97
	DC.B $79,$69,$59,$49,$39,$29,$19,$09
	DC.B $F9,$E9,$D9,$C9,$B9,$A9,$99
	DC.B $7B,$6B,$5B,$4B,$3B,$2B,$1B,$0B
	DC.B $FB,$EB,$DB,$CB,$BB,$AB,$9B
	DC.B $72,$62,$52,$42,$32,$22,$12,$02
	DC.B $F2,$E2,$D2,$C2,$B2,$A2,$92
	DC.B $74,$64,$54,$44,$34,$24,$14,$04
	DC.B $F4,$E4,$D4,$C4,$B4,$A4,$94
	DC.B $76,$66,$56,$46,$36,$26,$16,$06
	DC.B $F6,$E6,$D6,$C6,$B6,$A6,$96
	DC.B $78,$68,$58,$48,$38,$28,$18,$08
	DC.B $F8,$E8,$D8,$C8,$B8,$A8,$98
	DC.B $7A,$6A,$5A,$4A,$3A,$2A,$1A,$0A
	DC.B $FA,$EA,$DA,$CA,$BA,$AA,$9A
	DC.B $7C,$6C,$5C,$4C,$3C,$2C,$1C,$0C
	DC.B $FC,$EC,$DC,$CC,$BC,$AC
TRAP:	
	DC.B	$FF,$C3,$A5,$99,$99,$A5,$C3,$FF,$00,$00,$00,$00,$00,$00
EXPLO5: 
	DC.B	$00,$06,$0F,$0D,$19,$11,$13,$16,$1E,$0C,$24,$41,$00,$00
EXPLO6: 
	DC.B	$00,$0C,$1E,$1E,$3E,$3E,$3E,$3C,$3C,$18,$08,$00,$00,$00
FIRE1:
	DC.B	$2C,$2C,$2C,$2C,$2A,$2C,$2A,$28,$2C,$28,$2C,$2C,$2C,$2C
FIRE2:
	DC.B	$2C,$2C,$1A,$28,$28,$2C,$2E,$2A,$0A,$2E,$1E,$2A,$2C,$1E
FIRE3:
	DC.B	$2A,$2A,$1C,$26,$26,$2A,$2C,$28,$08,$2C,$1C,$28,$2A,$1C
FIRE4:
	DC.B	$28,$28,$1A,$24,$24,$28,$28,$26,$06,$2A,$1A,$26,$28,$1A
PLAYERD:
	DC.B	$38,$18,$1E,$1C,$1C,$3E,$3E,$3E,$1C,$1C,$1C,$1C,$0C,$04
PLAYERE:
	DC.B	$E6,$C7,$FE,$7C,$38,$6C,$5C,$5C,$38,$38,$38,$38,$30,$20
****
*
* BANK SWITCHING PORTION
*
****
	ORG	$FFE8
TBANK:
	LDA	$FFF9	;JUMP TO BANK 3 (TITLE BANK)
****
*
* ENTRY POINT TO BANK
*
****
	JMP	UPHORIZ
****
*
* JUMP FOR WRONG BANK
*
****
	ORG	$FFF0
KFIX:
	LDA	$FFF9
	JMP	KFIX
****
*
* RESET VECTORS
*
****
	ORG	$FFF8
	DC.B	$00,$00
	DC.W	KFIX	;IF WRONG BANK GOTO CORRECT ONE
	DC.W	KFIX
	DC.W	KFIX

